// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef MAIN_H
#define MAIN_H

#include "degub.h"
#include "ini.h"
#include "messages.h"
#include "corebase.h"
#include "resource.h"
#include <commctrl.h>
#include <d3d9.h>

int CALLBACK DegubberProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
int CALLBACK AOptionsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
int CALLBACK PadsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
int CALLBACK DebugOutputProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
int CALLBACK MemcardsProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
int CALLBACK CreateCardProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
void final_overrides();
#define DIK_BUFFER_SIZE 10
HRESULT SetBufferSize(LPDIRECTINPUTDEVICE pdiDevice, DWORD size);
bool MyGetOpenFileName(HWND hwndOwner, string& buffer, const char *title,
											 const char *filter);
bool MyGetSaveFileName(HWND hwndOwner, string& buffer, const char *title,
											 const char *filter, const char *defext);
#define FILTER_GCM "GameCube Media (*.gcm)\0*.GCM\0"

void emuDebug(const char* buffer);
void handleException(const exception& e);

#define WIDTH 640
#define HEIGHT 480

#define WM_MESSAGES(macro) \
	macro(WM_CREATE)\
	macro(WM_TIMER)\
	macro(WM_PAINT)\
	macro(WM_CLOSE)\
	macro(WM_DESTROY)\
	macro(WM_ACTIVATE)\
	macro(WM_COMMAND)\
	macro(WM_DROPFILES)\
	LAZER_MESSAGES(macro)

#define DECLARE_MESSAGE_HANDLER(mess) \
	long _##mess(HWND hWnd, WPARAM wParam, LPARAM lParam);

class CApp {
public:
	CApp() {
		ZERO_OBJECT(m);
	}
	~CApp() {
		MYASSERT(m.cpu == NULL);
		//SAFE_DELETE(m.cpu);
		cleanupD3D();
		cleanupDI();
	}
	bool run(HINSTANCE hInst, LPSTR lpszCmdLine);
	bool runemu();
	friend long CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	friend int WINAPI WinMain(HINSTANCE hInst, HINSTANCE, LPSTR lpszCmdLine, int);
	friend void handleException(const exception& e);

	HWND getHWnd() { return m.hWnd; }
	HACCEL getAccTable() { return m.hAccTable; }
	HWND getDWnd() { return m.hwndDegubber; }
	HWND getDOWnd() { return m.hwndDebugOutput; }
	CoreBase *getCPU() { return m.cpu; }
	LPDIRECTINPUTDEVICE getDIDevice() { return m.pdiDevice; }
	const string& getExeName() { return m_exename; }
	void SuspendEmuThread();
	void ResumeEmuThread();
private:
	CApp& operator=(const CApp&);

	RegistersBase m_old_dual_regs;
	std::vector<__int64> m_old_timings;
	string m_exename;
	struct ZEROABLE {
		CoreBase *cpu, *cpu1;
		Hardware *hw;
		//int fps, framecount;
		bool bActive;
		//bool snapshot_taken;
		HWND hWnd, hwndDegubber, hwndStatusBar, hwndDebugOutput, hwndVDO;
		HFONT hfontCourierNew;
		HACCEL hAccTable;
		bool recompiling;
		//char gcmname[MAX_PATH];
		bool lidopen;
		bool started_from_cmd_line;
		bool autopaused, temp_no_autopause;
		//CORE_TIMINGS old_ct;
		//LARGE_INTEGER ui_timing, old_ui_timing;
		bool wmp_error;
		bool emu_error; //set when an error occurs in emulation. should prevent restarting.

		LPDIRECT3D9 pD3D;
		LPDIRECT3DDEVICE9 pd3dDevice;
		D3DFORMAT d3dFormat;
		LPDIRECT3DSURFACE9 pd3dSurface;

		LPDIRECTINPUT pDI;
		LPDIRECTINPUTDEVICE pdiDevice;

		bool running, thread_running;
		HANDLE hThread;

		bool killed, frame_since_kill, lsync_since_last_timer;
		//DWORD restart_time;
		DWORD frames, old_frames;
		QWORD old_cycles, old_dsp_cycles;
		DWORD vst_count[_VST_MAX];
	} m;

	//Thread stuff
	bool createCores();
	bool cCcore();
	bool deleteCores();
	bool startThread();
	bool quitThread();
	friend unsigned __stdcall EmuThreadFunc(void *lpParam);

	bool initD3D();
	bool createSurface();
	void cleanupD3D();
	bool initDI();
	void cleanupDI();
	bool takeSnapshot(bool direct);
	bool setMenuChecks();
	bool setMenuGreyness();
	HRESULT updateFrameBuffer();
	bool parseCmdLine(LPSTR lpszCmdLine);
	void updateScreenAndKillTimer();
	bool createDebugOutput();
	void PostCloseMessage();

	enum Timers { SCREEN_TIMER=1, /*RESTART_TIMER,*/ CYCLE_TIMER };
#define INIT_INTERVAL (g::hrr ? (m.hw ? m.hw->getVDelay() : 1000) : 1000)
#define CYCLE_INTERVAL 1000

	WM_MESSAGES(DECLARE_MESSAGE_HANDLER)
};

extern CApp g_capp;
extern IniSystem g_ini;

#endif	//MAIN_H
